
'***************************************************************************
' VBIS4032.BAS
'
' VB/ISAM, VB/ISAM MX & VB/ISAM MU - Copyright (c) Software Source 1991-1995;
' all rights reserved.  VB/ISAM is a proprietary computer software product
' provided by its copyright holder, Software Source (13980 Blossom Hill Rd.,
' Los Gatos, CA); both the software and its documentation are copyrighted,
' and you may not copy or use either except as expressly provided
' in the VB/ISAM Software License.
'***************************************************************************

Option Explicit

Global Const VIS_OK = 0
Global Const VIS_NOT_FOUND = 1
Global Const VIS_UPDATE_VIOLATION = 2
Global Const VIS_ACCESS_DENIED = 3
Global Const VIS_BAD_DATASET_NUMBER = 4
Global Const VIS_BAD_FORMAT = 5
Global Const VIS_INVALID_KEY = 6
Global Const VIS_BAD_PARAMETER_VALUE = 7
Global Const VIS_BAD_FILE = 8
Global Const VIS_ALREADY_EXISTS = 9
Global Const VIS_NO_ROOM = 10
Global Const VIS_DISK_FULL = 11
Global Const VIS_OUT_OF_MEMORY = 12
Global Const VIS_DOS_ERROR = 13
Global Const VIS_DISK_ERROR = 14
Global Const VIS_DATA_VALIDITY_CHECK = 15
Global Const VIS_INVALID_SECONDARY_KEY = 16
Global Const VIS_SEQUENCE_ERROR = 17
Global Const VIS_OUT_OF_FILE_HANDLES = 18
Global Const VIS_BUSY = 19
Global Const VIS_INVALID_PASSWORD = 20
Global Const VIS_FUNCTION_NOT_AVAILABLE = 21
Global Const VIS_INTERUPTED = 22

Global Const ADD_OR_REPLACE = 0
Global Const ADD_ONLY = 1
Global Const REPLACE_ONLY = 2

Global Const READ_ONLY = 0
Global Const READ_WRITE = 1
Global Const READ_ONLY_SHARE = 2
Global Const READ_ONLY_SHARED = 2
Global Const READ_WRITE_SHARE = 3
Global Const READ_WRITE_SHARED = 3

Global Const XNOFINDER = 1
Global Const XLOOKUP = 1
Global Const XNEXT = 2
Global Const XPREVIOUS = 4
Global Const XCURRENT = 8

Global Const XANY = 16
Global Const XEQ = 32
Global Const XBEGINS = 64
Global Const XNOT = 128
Global Const XLT = 256
Global Const XGT = 512
Global Const XLE = 1024
Global Const XGE = 2048

Global Const XGET_DATA = 4096
Global Const XNO_DATA = 8192
Global Const XNATIVE = 16384

Global Const NO_CACHE = -1
Global Const SMALL_CACHE = 0
Global Const LARGE_CACHE = 1

Type VBISAMInfo
    RecordsInFile           As Long
    GroupsUsed              As Integer
    AllocatedGpsAvail       As Integer
    MaxPrimaryKeyLen        As Integer
    GroupSize               As Long
    InitialAllocation       As Integer
    IncrementalAllocation   As Integer
    FreeFileNoteSpace       As Integer
    StandardFormat          As String
    Reserved                As String
End Type

'***************************************************************************

Declare Function VmxCreate Lib "vbis4032.DLL" (DatasetName$, MaxKeyLength%, GroupSize&, InitialAllocation%, CreateOptions%, RecFormat$) As Integer
Declare Function VmxKill Lib "vbis4032.DLL" (DatasetName$) As Integer

Declare Function VmxOpen Lib "vbis4032.DLL" (DatasetName$, LocatorLength%, AccessMode%, RHandle&, Password$) As Integer
Declare Function VmxClose Lib "vbis4032.DLL" (DatasetHandle&) As Integer

Declare Function VmxPut Lib "vbis4032.DLL" (DatasetHandle&, Key$, RecordVariable As Any, UpdateMode%) As Integer
Declare Function VmxDelete Lib "vbis4032.DLL" (DatasetHandle&, Key$) As Integer

Declare Function VmxGet Lib "vbis4032.DLL" (DatasetHandle&, SecIndexField%, Options%, SelectorKey$, RSecondaryKey$, RPrimaryKey$, RRecordVariable As Any) As Integer

Declare Function VmxBOF Lib "vbis4032.DLL" (DatasetHandle&, SecIndexField%) As Integer
Declare Function VmxEOF Lib "vbis4032.DLL" (DatasetHandle&, SecIndexField%) As Integer

Declare Function VmxWriteNote Lib "vbis4032.DLL" (DatasetHandle&, AttributeStringName$, AttributeStringContents$) As Integer
Declare Function VmxReadNote Lib "vbis4032.DLL" (DatasetHandle&, Aname$, RAcontents$) As Integer

Declare Function VmxFlush Lib "vbis4032.DLL" (DatasetHandle&) As Integer

Declare Function VmxInfo Lib "vbis4032.DLL" (DatasetHandle&, VBISAMInfoStruct As VBISAMInfo) As Integer
Declare Function VmxReturnCode Lib "vbis4032.DLL" (FunctionReturnCode%) As String

Declare Function VmxEncode Lib "vbis4032.DLL" (InStructure As Any, RecFormat$, ROutString$) As Integer
Declare Function VmxDecode Lib "vbis4032.DLL" (InString$, RecFormat$, ROutStructure As Any) As Integer

' multiuser functions

Declare Function VmxLock Lib "vbis4032.DLL" (DatasetHandle&, Key$) As Integer
Declare Function VmxUnlock Lib "vbis4032.DLL" (DatasetHandle&, Key$) As Integer

Declare Function VmxHash Lib "vbis4032.DLL" (DatasetHandle&, Key$) As Long

' field functions

Declare Function VmxStoreField Lib "vbis4032.DLL" (DatasetHandle&, RecFormat$, Record$, FieldNo%, FieldType$, FldData As Any) As Integer
Declare Function VmxFetchField Lib "vbis4032.DLL" (DatasetHandle&, RecFormat$, Record$, FieldNo%, FieldType$, RFldData As Any) As Integer
Declare Function VmxFieldNumber Lib "vbis4032.DLL" (DatasetHandle&, FieldName$) As Integer

' debuging functions

'  Declare Function VmxExtendedError Lib "vbis4032.DLL" (DatasetHandle&, RExtendedError%) As Integer
'  Declare Function VmxBreak Lib "vbis4032.DLL" (Flg%) As Integer

' joke funciton

'Declare Function VmxHaltOnImpendingError Lib "vbis4032.DLL" (Argument1$, Argument2$) As Integer

' new funciton

Declare Function VmxMovePtr Lib "vbis4032.DLL" (DatasetHandle&, SecIndexField%, RelativeCount&, XOption%) As Integer
Declare Function VmxCancel Lib "vbis4032.DLL" (DatasetHandle&) As Integer

' VB/ISAM map and finder functions

Declare Function VmxFix    Lib "vbis4032.DLL" (DatasetName$, Opts%) As Integer
Declare Function VmxVal    Lib "vbis4032.DLL" (DatasetName$, Ebuf$, Opts%) As Integer

' End vbis4032.BAS
'****************************************************************************

